unit PubPropertyInfo;
interface

uses
// --------------------------------
//     
Windows, Messages, SysUtils, Variants, Classes,
Graphics, Controls, Forms, Dialogs,
// --------------------------------
StrUtils,Menus, ImgList, ComCtrls, StdCtrls, Buttons,
Grids, ExtCtrls,
// --------------------------------
TypInfo;


//       
procedure EnumClassProrerty(RqClass  : TClass;
                            RepTitle : TStaticText;
                            RepList  : TStringGrid);

// =========================================================================
// =========================================================================
implementation

// =========================================================================
//      UNIT TypInfo
// =========================================================================
//       
procedure ShowClassProrerty (PListProp : PPropList;
                             PropCount : Integer;
                             Report    : TStringGrid);
const TitArr : array[0..3] of string =
             ('Kind', ' ', ' ', 'Unit');
var   Ind    : integer;
      WStr   : string;
      ATypeData  : PTypeData;  //     
begin
  //      
  if not (Assigned(PListProp) and (PropCount > 0))
  then begin
     //   
     Report.FixedRows := 1;
     Report.RowCount  := 2;
     for Ind := Low(TitArr) to High(TitArr)
     do begin
       Report.Cells[Ind,0] := TitArr[Ind];
       Report.Cells[Ind,1] := '';
     end;
  end
  else begin
     //   
     Report.RowCount   := PropCount + 1;
     Report.FixedRows  := 1;
     for Ind := Low(TitArr) to High(TitArr)
     do  Report.Cells[Ind,0] := TitArr[Ind];
     //  
     for Ind := 0 to PropCount - 1 do
     begin
        //   
        WStr := GetEnumName(TypeInfo(TTypeKind),
                            Integer(PListProp^[Ind].PropType^.Kind));
        Report.Cells[0, Ind + Report.FixedRows] := Wstr;
        //    
        Report.Cells[1, Ind + Report.FixedRows] := PListProp^[Ind].Name;
        //    
        Report.Cells[2, Ind + Report.FixedRows] := PListProp^[Ind].PropType^.Name;
        //     ,    Unit  
        Report.Cells[3, Ind + Report.FixedRows] := '';
        //       
        ATypeData  := GetTypeData(PListProp^[Ind].PropType^);
        if Assigned (ATypeData)
        then begin
          if (PListProp^[Ind].PropType^.Kind = tkClass)
          then begin
               //   Unit
               Report.Cells[3, Ind + Report.FixedRows] := ATypeData^.UnitName;
          end;
        end;
     end;
  end;
end;

//       
procedure EnumClassProrerty(RqClass  : TClass;
                            RepTitle : TStaticText;
                            RepList  : TStringGrid);
var
  ATypeInfo  : PTypeInfo;  //   
  ATypeData  : PTypeData;  //     
  PropCount  : Integer;    //  
  PListProp  : PPropList;  //   
  EnProp     : boolean;    //  -  
begin
  EnProp     := False;
  PListProp  := nil;
  //        
  ATypeInfo  := PTypeInfo(RqClass.ClassInfo);
  if Assigned(ATypeInfo)
  then begin
     ATypeData  := GetTypeData(ATypeInfo);
     if Assigned (ATypeData)
     then begin
       EnProp   := True;
       //     
       PropCount  := ATypeData^.PropCount;
       if PropCount > 0 then
       begin
          GetMem(PListProp, PropCount * SizeOf(Pointer));
          //    
          GetPropInfos(ATypeInfo, PListProp);
          //   
          ShowClassProrerty(PListProp, PropCount, RepList);
          FreeMem(PListProp, PropCount * SizeOf(Pointer));
       end
       else ShowClassProrerty(PListProp, PropCount, RepList);
       //  
       RepTitle.Caption := ' Unit : '
                         + ATypeData^.UnitName
                         + ',  : ' + RqClass.ClassName
                         + ',   : '
                         + IntToStr(PropCount);
     end;
  end;
  if not EnProp
  then begin
     RepTitle.Caption := ' ' + RqClass.ClassName
                       + ' :  ';
     ShowClassProrerty(nil, 0, RepList);
  end;
end;

end.
